/*
 * Decompiled with CFR 0.152.
 */
package emulator.shell.GUI.profiling;

import emulator.assembler.AddressDictionary;
import emulator.hardware.HwWord;
import emulator.hardware.debug.profiling.CodeSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.tree.TreeNode;

public class CallTreeModelData
implements TreeNode {
    private CallTreeModelData parent = null;
    private List<CallTreeModelData> children = new ArrayList<CallTreeModelData>();
    private String label;
    private int address;

    public CallTreeModelData() {
        this.label = "";
        this.address = -1;
    }

    public CallTreeModelData(CodeSegment codeSegment, AddressDictionary labelMap, Set<CodeSegment> visited) {
        this.label = String.valueOf(labelMap.getLabel(codeSegment.getEnterAddress())) + " ($" + new HwWord((long)codeSegment.getEnterAddress()) + " ,#=" + codeSegment.getCallCount() + " ,Tot.=" + codeSegment.getSumTicks() + " ,Seg.=" + (codeSegment.getSumTicks() - codeSegment.getSubTicks()) + ")";
        this.address = codeSegment.getEnterAddress();
        if (!visited.contains(codeSegment)) {
            visited.add(codeSegment);
            for (CodeSegment child : codeSegment.getChildren()) {
                this.children.add(new CallTreeModelData(child, labelMap, visited));
            }
            visited.remove(codeSegment);
        }
    }

    public String toString() {
        return this.label;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Enumeration<CallTreeModelData> children() {
        return Collections.enumeration(this.children);
    }

    public void addChild(CodeSegment codeSegment, AddressDictionary labelMap) {
        this.children.add(new CallTreeModelData(codeSegment, labelMap, new HashSet<CodeSegment>()));
    }

    public int getAddress() {
        return this.address;
    }
}

